<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwindex="urn:WebWorks-Index-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwindex wwlinks wwmode wwfiles wwdoc wwsplits wwvars wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Page template include files -->
 <!--                             -->
 <xsl:variable name="GlobalPageTemplateIncludeFilesAsXML">
  <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-include-files">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
  </xsl:apply-templates>
 </xsl:variable>
 <xsl:variable name="GlobalPageTemplateIncludeFiles" select="msxsl:node-set($GlobalPageTemplateIncludeFilesAsXML)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Generate Index? -->
   <!--                 -->
   <xsl:if test="wwprojext:GetFormatSetting('index-generate', 'true') = 'true'">
    <!-- Iterate input documents -->
    <!--                         -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

     <xsl:variable name="VarProgressFilesStart" select="wwprogress:Start(count($VarFilesByType))" />

     <xsl:for-each select="$VarFilesByType">
      <xsl:variable name="VarProgressFileStart" select="wwprogress:Start(1)" />

      <xsl:variable name="VarFilesDocument" select="." />

      <!-- Load splits -->
      <!--             -->
      <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterSplitsType))[1]" />
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

      <xsl:for-each select="$VarSplits[1]">
       <!-- Split -->
       <!--       -->
       <xsl:variable name="VarSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

       <!-- Transform -->
       <!--           -->
       <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, '', $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
       <xsl:if test="not($VarUpToDate)">
        <xsl:variable name="VarResultAsXML">
         <!-- Load document -->
         <!--               -->
         <xsl:variable name="VarIndex" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

         <xsl:call-template name="Index">
          <xsl:with-param name="ParamSplits" select="$VarSplits" />
          <xsl:with-param name="ParamIndex" select="$VarIndex" />
          <xsl:with-param name="ParamSplit" select="$VarSplit" />
         </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
        <xsl:variable name="VarPrettyPrint">
         <xsl:choose>
          <xsl:when test="wwprojext:GetFormatSetting('file-processing-pretty-print') = 'true'">
           <xsl:text>yes</xsl:text>
          </xsl:when>

          <xsl:otherwise>
           <xsl:text>no</xsl:text>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:variable>
        <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'html', '5.0', $VarPrettyPrint, 'yes', 'no', 'urn:WebWorks_DOCTYPE_ElementOnly', '')" />
       </xsl:if>

       <!-- Report Files -->
       <!--              -->
       <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
        <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
        <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />

        <!-- Page Template Include Files -->
        <!--                             -->
        <xsl:for-each select="$GlobalPageTemplateIncludeFiles">
         <xsl:variable name="VarFile" select="." />

         <wwfiles:Depends path="{$VarFile/@path}" checksum="{wwfilesystem:GetChecksum($VarFile/@path)}" groupID="" documentID="" />
        </xsl:for-each>
       </wwfiles:File>
      </xsl:for-each>

      <xsl:variable name="VarProgressFileEnd" select="wwprogress:End()" />
     </xsl:for-each>

     <xsl:variable name="VarProgressFilesEnd" select="wwprogress:End()" />
    </xsl:for-each>
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Index">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamIndex" />
  <xsl:param name="ParamSplit" />

  <!-- Split files -->
  <!--             -->
  <xsl:for-each select="$ParamSplits[1]">
   <!-- Conditions -->
   <!--            -->
   <xsl:variable name="VarConditionsAsXML">
    <!-- No conditions at this time -->
    <!--                            -->
   </xsl:variable>
   <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

   <!-- Replacements -->
   <!--              -->
   <xsl:variable name="VarReplacementsAsXML">
    <wwpage:Replacement name="title" value="{$ParamSplit/@title}" />

    <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
    <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

    <!-- index-id -->
    <!--          -->
    <wwpage:Replacement name="index-id" value="index:{$ParamSplit/@groupID}" />

    <!-- Content -->
    <!--         -->
    <wwpage:Replacement name="content">
     <xsl:call-template name="Content-Content">
      <xsl:with-param name="ParamContent" select="$ParamIndex" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:call-template>
    </wwpage:Replacement>

    <!-- Variables -->
    <!--           -->
    <xsl:variable name="VarPageVariablesAsXML">
     <xsl:for-each select="$GlobalProjectVariables[1]">
      <xsl:variable name="VarVariablesGroup" select="key('wwvars-groups-by-groupid', $ParamSplit/@groupID)[1]" />

      <xsl:call-template name="Variables-Filter-Last-Unique">
       <xsl:with-param name="ParamVariables" select="$VarVariablesGroup//wwvars:Variable" />
      </xsl:call-template>
     </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="VarPageVariables" select="msxsl:node-set($VarPageVariablesAsXML)/wwvars:Variable" />
    <xsl:call-template name="Variables-Page-String-Replacements">
     <xsl:with-param name="ParamVariables" select="$VarPageVariables" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

   <!-- Map common characters -->
   <!--                       -->
   <wwexsldoc:MappingContext>
    <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

    <!-- Invoke page template -->
    <!--                      -->
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
     <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
     <xsl:with-param name="ParamOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwstring:ReplaceWithExpression(wwstring:Replace(wwprojext:GetGroupName($ParamSplit/@groupID), $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'))" />
     <xsl:with-param name="ParamOutputPath" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamConditions" select="$VarConditions" />
     <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
    </xsl:apply-templates>
   </wwexsldoc:MappingContext>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content-Content">
  <xsl:param name="ParamContent" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />

  <xsl:call-template name="Sections">
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   <xsl:with-param name="ParamIndex" select="$ParamContent/wwindex:Index" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Sections">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamIndex" />

  <xsl:for-each select="$ParamIndex/wwindex:Section">
   <xsl:variable name="VarSection" select="." />

   <html:dl>

    <xsl:call-template name="Groups">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamSection" select="$VarSection" />
    </xsl:call-template>

   </html:dl>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Groups">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSection" />

  <xsl:for-each select="$ParamSection/wwindex:Group">
   <xsl:variable name="VarGroup" select="." />

   <html:dd>

    <html:div class="ww_skin_index_group">
     <xsl:value-of select="$VarGroup/@name" />
    </html:div>

    <html:dl>

     <xsl:call-template name="Entries">
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamParent" select="$VarGroup" />
     </xsl:call-template>

    </html:dl>

   </html:dd>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParent" />

  <xsl:for-each select="$ParamParent/wwindex:Entry">
   <xsl:variable name="VarEntry" select="." />

   <html:dd>

    <xsl:variable name="VarSee" select="$VarEntry/wwindex:See[1]" />

    <xsl:choose>
     <xsl:when test="count($VarSee) = 1">
      <!-- See/See Also -->
      <!--              -->
      <html:div class="ww_skin_index_entry">
       <html:a class="ww_skin_index_link">
        <xsl:attribute name="rel">
         <xsl:text>See</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="href">
         <xsl:text>#</xsl:text>
         <xsl:text>ww:</xsl:text>
         <xsl:value-of select="$ParamSplit/@groupID" />
         <xsl:text>:</xsl:text>
         <xsl:value-of select="$VarSee/@entryID" />
        </xsl:attribute>

        <xsl:call-template name="Content">
         <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
        </xsl:call-template>
       </html:a>
      </html:div>
     </xsl:when>

     <xsl:otherwise>
      <!-- Regular entry -->
      <!--               -->
      <xsl:variable name="VarLinks" select="$VarEntry/wwindex:Link" />

      <xsl:choose>
       <xsl:when test="count($VarLinks) = 0">
        <!-- Emit entry without any links -->
        <!--                              -->
        <html:div class="ww_skin_index_entry">
         <xsl:if test="string-length($VarEntry/@id) &gt; 0">
          <xsl:attribute name="id">
           <xsl:text>ww:</xsl:text>
           <xsl:value-of select="$ParamSplit/@groupID" />
           <xsl:text>:</xsl:text>
           <xsl:value-of select="$VarEntry/@id" />
          </xsl:attribute>
         </xsl:if>

         <xsl:call-template name="Content">
          <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
         </xsl:call-template>
        </html:div>
       </xsl:when>

       <xsl:when test="(count($VarLinks) = 1) and (count($VarLinks[1]/wwdoc:Content[1]) = 0)">
        <!-- Wrap link directly around entry -->
        <!--                                 -->
        <xsl:variable name="VarLink" select="$VarLinks[1]" />
        <html:div class="ww_skin_index_entry">
         <xsl:if test="string-length($VarEntry/@id) &gt; 0">
          <xsl:attribute name="id">
           <xsl:text>ww:</xsl:text>
           <xsl:value-of select="$ParamSplit/@groupID" />
           <xsl:text>:</xsl:text>
           <xsl:value-of select="$VarEntry/@id" />
          </xsl:attribute>
         </xsl:if>

         <xsl:variable name="VarRelativeLinkPath">
          <xsl:call-template name="Connect-URI-GetRelativeTo">
           <xsl:with-param name="ParamDestinationURI" select="$VarLink/@href" />
           <xsl:with-param name="ParamSourceURI" select="$ParamSplit/@path" />
          </xsl:call-template>
         </xsl:variable>

         <html:a class="ww_skin_index_link">
          <xsl:attribute name="href">
           <xsl:value-of select="$VarRelativeLinkPath" />
           <xsl:if test="$VarLink/@first != 'true'">
            <xsl:text>#</xsl:text>
            <xsl:text>ww</xsl:text>
            <xsl:value-of select="$VarLink/@anchor" />
           </xsl:if>
          </xsl:attribute>

          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </html:a>
        </html:div>
       </xsl:when>

       <xsl:otherwise>
        <!-- Emit entry followed by links -->
        <!--                              -->
        <html:div class="ww_skin_index_entry">
         <xsl:if test="string-length($VarEntry/@id) &gt; 0">
          <xsl:attribute name="id">
           <xsl:text>ww:</xsl:text>
           <xsl:value-of select="$ParamSplit/@groupID" />
           <xsl:text>:</xsl:text>
           <xsl:value-of select="$VarEntry/@id" />
          </xsl:attribute>
         </xsl:if>

         <xsl:call-template name="Content">
          <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
         </xsl:call-template>

         <!-- Links -->
         <!--       -->
         <xsl:for-each select="$VarLinks">
          <xsl:variable name="VarLink" select="." />

          <!-- Space things out a bit -->
          <!--                        -->
          <xsl:if test="position() &gt; 1">
           <xsl:text>,</xsl:text>
          </xsl:if>
          <xsl:text> </xsl:text>

          <xsl:variable name="VarRelativeLinkPath">
           <xsl:call-template name="Connect-URI-GetRelativeTo">
            <xsl:with-param name="ParamDestinationURI" select="$VarLink/@href" />
            <xsl:with-param name="ParamSourceURI" select="$ParamSplit/@path" />
           </xsl:call-template>
          </xsl:variable>

          <xsl:choose>
           <xsl:when test="count($VarLink/wwdoc:Content[1]) = 1">
            <!-- Link has explicit text to show -->
            <!--                                -->
            <xsl:variable name="VarLinkSee" select="$VarLink/wwdoc:See[1]" />
            <xsl:choose>
             <xsl:when test="count($VarLinkSee) = 1">
              <!-- See/See Also link redirect -->
              <!--                            -->
              <html:a class="ww_skin_index_link">
               <xsl:attribute name="rel">
                <xsl:text>See</xsl:text>
               </xsl:attribute>
               <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:text>ww:</xsl:text>
                <xsl:value-of select="$ParamSplit/@groupID" />
                <xsl:text>:</xsl:text>
                <xsl:value-of select="$VarLinkSee/@entryID" />
               </xsl:attribute>

               <xsl:call-template name="Content">
                <xsl:with-param name="ParamContent" select="$VarLink/wwdoc:Content[1]" />
               </xsl:call-template>
              </html:a>
             </xsl:when>

             <xsl:otherwise>
              <!-- Wrap link around content -->
              <!--                          -->
              <html:a class="ww_skin_index_link">
               <xsl:attribute name="href">
                <xsl:value-of select="$VarRelativeLinkPath" />
                <xsl:if test="$VarLink/@first != 'true'">
                 <xsl:text>#</xsl:text>
                 <xsl:text>ww</xsl:text>
                 <xsl:value-of select="$VarLink/@anchor" />
                </xsl:if>
               </xsl:attribute>

               <xsl:call-template name="Content">
                <xsl:with-param name="ParamContent" select="$VarLink/wwdoc:Content[1]" />
               </xsl:call-template>
              </html:a>
             </xsl:otherwise>
            </xsl:choose>
           </xsl:when>

           <xsl:otherwise>
            <!-- Emit numbered entry -->
            <!--                     -->
            <html:a class="ww_skin_index_link">
             <xsl:attribute name="href">
              <xsl:value-of select="$VarRelativeLinkPath" />
              <xsl:if test="$VarLink/@first != 'true'">
               <xsl:text>#</xsl:text>
               <xsl:text>ww</xsl:text>
               <xsl:value-of select="$VarLink/@anchor" />
              </xsl:if>
             </xsl:attribute>

             <xsl:value-of select="position()" />
            </html:a>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:for-each>
        </html:div>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>

    <!-- Process children -->
    <!--                  -->
    <xsl:for-each select="$VarEntry/wwindex:Entry[1]">
     <html:dl>

      <xsl:call-template name="Entries">
       <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       <xsl:with-param name="ParamParent" select="$VarEntry" />
      </xsl:call-template>

     </html:dl>
    </xsl:for-each>

   </html:dd>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content">
  <xsl:param name="ParamContent" />

  <!-- Simple processing for now -->
  <!--                           -->
  <xsl:for-each select="$ParamContent/wwdoc:TextRun/wwdoc:Text">
   <xsl:value-of select="@value" />
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
